﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Drawing.Printing

Public Class MainForm

    ''' <summary>
    ''' PrintDialog 允许用户选择要打印到 
    ''' 的打印机，以及其他打印选项。
    ''' </summary>
    Private Sub btnPrintDialog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrintDialog.Click
        PrintDialog1.Document = PrintDocument1
        If PrintDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            PrintDocument1.Print()
        End If
    End Sub

    ' 
    ''' <summary>
    ''' 在呈现预览时，PrintPreviewDialog 与 PrintDocument 相关联,
    ''' 并触发 PrintPage 事件。向 PrintPage 事件传递
    ''' 一个在其中“绘制”页的图形上下文。
    ''' </summary>
    Private Sub btnPrintPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrintPreview.Click
        Try
            PrintPreviewDialog1.Document = PrintDocument1
            PrintPreviewDialog1.ShowDialog()
        Catch exp As Exception
            MsgBox("An error occurred while trying to load the " & _
                "document for Print Preview. Make sure you currently have " & _
                "access to a printer. A printer must be connected and " & _
                "accessible for Print Preview to work.", MsgBoxStyle.OkOnly, _
                 Me.Text)
        End Try
    End Sub

    ''' <summary>
    ''' 使用页面设置可以指定纸张大小、纵向、 
    ''' 横向等内容。
    ''' </summary>
    Private Sub btnPageSetup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPageSetup.Click
        With PageSetupDialog1
            .Document = PrintDocument1
            .PageSettings = PrintDocument1.DefaultPageSettings
        End With

        If PageSetupDialog1.ShowDialog = Windows.Forms.DialogResult.OK Then
            PrintDocument1.DefaultPageSettings = PageSetupDialog1.PageSettings
        End If
    End Sub

    ''' <summary>
    ''' 处理窗体的 Load 事件，用一些文本初始化
    ''' TextBox 以便打印。
    ''' </summary>
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        txtDocument.Text = My.Resources.Address
    End Sub


    ''' <summary>
    ''' PrintPage 是打印事件。对于要打印的每一页
    ''' 都会激发此事件。也可以处理 BeginPrint 和
    ''' EndPrint 事件以获得更多的控制。
    ''' 
    ''' 下面的代码 
    ''' 对纯文本的执行速度很快且很有用，
    ''' 因为 MeasureString 计算可以适合整页的文本。但是，对于 
    ''' 格式化文本则不那么有用。如果是格式化文本，则需要具有更加复杂的
    ''' 字级别（相对于页级别）控件。
    ''' </summary>
    Private Sub pdoc_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        ' 声明一个变量来保存最后一个打印字符的位置。声明为
        ' 静态以便后面的 PrintPage 事件可以引用该变量。
        Static intCurrentChar As Int32
        ' 初始化要用于打印的字体。
        Dim font As New Font("Microsoft Sans Serif", 24)

        Dim intPrintAreaHeight, intPrintAreaWidth, marginLeft, marginTop As Int32
        With PrintDocument1.DefaultPageSettings
            ' 初始化包含打印区域矩形的
            ' 边界的局部变量。
            intPrintAreaHeight = .PaperSize.Height - .Margins.Top - .Margins.Bottom
            intPrintAreaWidth = .PaperSize.Width - .Margins.Left - .Margins.Right

            ' 初始化局部变量以保存将用作打印区域
            ' 矩形左上角的 X 和 Y 坐标 
            ' 的边距值。
            marginLeft = .Margins.Left ' X 坐标
            marginTop = .Margins.Top ' Y 坐标
        End With

        ' 如果用户选择了“横向”模式，则交换打印区域的高度与
        ' 宽度。
        If PrintDocument1.DefaultPageSettings.Landscape Then
            Dim intTemp As Int32
            intTemp = intPrintAreaHeight
            intPrintAreaHeight = intPrintAreaWidth
            intPrintAreaWidth = intTemp
        End If

        ' 根据打印区域的高度和字体的
        ' 高度计算文档中的总行数。
        Dim intLineCount As Int32 = CInt(intPrintAreaHeight / font.Height)
        ' 初始化定义打印区域的矩形结构。
        Dim rectPrintingArea As New RectangleF(marginLeft, marginTop, intPrintAreaWidth, intPrintAreaHeight)

        ' 将 StringFormat 类实例化，该类封装文本布局
        ' 信息（如对齐方式和行距），显示操作 
        ' （如省略号插入和区域数字替换）和 OpenType 
        ' 功能。使用 StringFormat 可使
        ' MeasureString 和 DrawString 在打印每页时仅使用整数行，
        ' 而忽略非完整行。如果每页的打印区域高度不能整除每页的行数（通常都会如此），
        ' 非完整行在其他情况下可能会打印。
        ' 请参见 SDK 文档中有关 StringFormatFlags 的进一步讨论。
        Dim fmt As New StringFormat(StringFormatFlags.LineLimit)
        ' 调用 MeasureString 确定适合打印区域矩形
        ' 的字符数。向 CharFitted Int32 传递 ByRef，并在稍后用于
        ' 计算 intCurrentChar，进而计算 HasMorePages。LinesFilled 
        ' 对于本示例不是必要的，但必须在传递 CharsFitted 时进行传递。
        ' Mid 用于传递从打印的上一页断开的
        ' 剩余文本段（回想一下，intCurrentChar 是声明为
        ' 静态的）。
        Dim intLinesFilled, intCharsFitted As Int32
        e.Graphics.MeasureString(Mid(txtDocument.Text, intCurrentChar + 1), font, _
                    New SizeF(intPrintAreaWidth, intPrintAreaHeight), fmt, _
                    intCharsFitted, intLinesFilled)

        ' 将文本打印到页。
        e.Graphics.DrawString(Mid(txtDocument.Text, intCurrentChar + 1), font, _
            Brushes.Black, rectPrintingArea, fmt)

        ' 使当前字符前进到在此页上打印的最后一个字符。因为 
        ' intCurrentChar 是静态变量，所以它的值可以用于
        ' 要打印的下一页。使它前进 1 个字符并将其传递到 Mid()
        ' 以打印下一页（请参见上面 MeasureString()）。
        intCurrentChar += intCharsFitted

        ' HasMorePages 通知打印模块是否应激发
        ' 另一个 PrintPage 事件。
        If intCurrentChar < txtDocument.Text.Length Then
            e.HasMorePages = True
        Else
            e.HasMorePages = False
            ' 因为 intCurrentChar 是静态的，所以必须显式重置它。
            intCurrentChar = 0
        End If
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
